/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.download.workers;

import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import net.ftb.download.info.DownloadInfo;
import net.ftb.log.Logger;
import net.ftb.util.DownloadUtils;

public class AssetDownloader
extends SwingWorker<Boolean, Void> {
    private List<DownloadInfo> downloads;
    private final ProgressMonitor monitor;
    private int progressIndex = 0;
    private boolean allDownloaded = true;
    private String status;
    private int ready = 0;

    public AssetDownloader(ProgressMonitor monitor, List<DownloadInfo> downloads) {
        this.downloads = downloads;
        this.monitor = monitor;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        for (DownloadInfo download : this.downloads) {
            if (this.isCancelled()) {
                return false;
            }
            this.doDownload(download);
        }
        this.setStatus(this.allDownloaded ? "Success" : "Downloads failed");
        return this.allDownloaded;
    }

    public synchronized void setReady(int newReady) {
        int oldReady = this.ready;
        this.ready = newReady;
        this.firePropertyChange("ready", oldReady, this.ready);
    }

    public synchronized void setStatus(String newStatus) {
        String oldStatus = this.status;
        this.status = newStatus;
        this.firePropertyChange("note", oldStatus, this.status);
    }

    private void doDownload(DownloadInfo asset) {
        byte[] buffer = new byte[24000];
        boolean downloadSuccess = false;
        List<String> remoteHash = asset.hash;
        int attempt = 0;
        int attempts = 5;
        while (!downloadSuccess && attempt < 5) {
            try {
                int readLen;
                URLConnection con;
                if (remoteHash == null) {
                    remoteHash = Lists.newArrayList();
                }
                String hashType = asset.hashType;
                if (attempt++ > 0) {
                    Logger.logInfo("Connecting.. Try " + attempt + " of " + 5 + " for: " + asset.url);
                }
                if ((con = asset.url.openConnection()) instanceof HttpURLConnection) {
                    con.setRequestProperty("Cache-Control", "no-cache, no-transform");
                    ((HttpURLConnection)con).setRequestMethod("HEAD");
                    con.connect();
                }
                long remoteSize = Long.parseLong(con.getHeaderField("Content-Length"));
                if (asset.hash == null && asset.getPrimaryDLType() == DownloadInfo.DLType.ETag) {
                    remoteHash.clear();
                    remoteHash.add(con.getHeaderField("ETag").replace("\"", ""));
                    hashType = "md5";
                }
                if (asset.hash == null && asset.getPrimaryDLType() == DownloadInfo.DLType.ContentMD5) {
                    remoteHash.clear();
                    remoteHash.add(con.getHeaderField("Content-MD5").replace("\"", ""));
                    hashType = "md5";
                }
                Logger.logDebug(asset.name);
                Logger.logDebug("RemoteSize: " + remoteSize);
                Logger.logDebug("asset.hash: " + asset.hash);
                Logger.logDebug("remoteHash: " + remoteHash);
                if (asset.local.exists()) {
                    long localSize = asset.local.length();
                    if (!(con instanceof HttpURLConnection) || localSize != remoteSize) {
                        asset.local.delete();
                        Logger.logWarn("Local asset size differs from remote size: " + asset.name + " remote: " + remoteSize + " local: " + localSize);
                    }
                }
                if (asset.local.exists()) {
                    this.doHashCheck(asset, remoteHash);
                }
                if (asset.local.exists()) {
                    downloadSuccess = true;
                    ++this.progressIndex;
                    continue;
                }
                this.setProgress(0);
                this.setStatus("Downloading " + asset.name + "...");
                con = asset.url.openConnection();
                if (con instanceof HttpURLConnection) {
                    con.setRequestProperty("Cache-Control", "no-cache, no-transform");
                    ((HttpURLConnection)con).setRequestMethod("GET");
                    con.connect();
                }
                asset.local.getParentFile().mkdirs();
                int currentSize = 0;
                InputStream input = con.getInputStream();
                FileOutputStream output = new FileOutputStream(asset.local);
                while ((readLen = input.read(buffer, 0, buffer.length)) != -1) {
                    output.write(buffer, 0, readLen);
                    int prog = (int)((long)(currentSize += readLen) / remoteSize * 100L);
                    if (prog > 100) {
                        prog = 100;
                    }
                    if (prog < 0) {
                        prog = 0;
                    }
                    this.setProgress(prog);
                    prog = this.progressIndex * 100 + prog;
                    this.setReady(prog);
                }
                input.close();
                output.close();
                if (!(con instanceof HttpURLConnection) || currentSize <= 0 || (long)currentSize != remoteSize) {
                    asset.local.delete();
                    Logger.logWarn("Local asset size differs from remote size: " + asset.name + " remote: " + remoteSize + " local: " + currentSize);
                }
                if (!(downloadSuccess = this.doHashCheck(asset, remoteHash))) continue;
                ++this.progressIndex;
            }
            catch (Exception e) {
                downloadSuccess = false;
                Logger.logWarn("Connection failed, trying again", e);
            }
        }
        if (!downloadSuccess) {
            this.allDownloaded = false;
        }
    }

    public boolean doHashCheck(DownloadInfo asset, List<String> remoteHash) throws IOException {
        String hash = DownloadUtils.fileHash(asset.local, asset.hashType).toLowerCase();
        List<String> assetHash = asset.hash;
        boolean good = false;
        if (asset.hash == null) {
            if (remoteHash != null) {
                assetHash = remoteHash;
            } else if (asset.getBackupDLType() == DownloadInfo.DLType.FTBBackup && DownloadUtils.backupIsValid(asset.local, asset.url.getPath().replace("/FTB2", ""))) {
                good = true;
            }
        }
        if (good || assetHash != null && assetHash.contains(hash)) {
            return true;
        }
        Logger.logWarn("Asset hash checking failed: " + asset.name + " " + asset.hashType + " " + hash);
        asset.local.delete();
        return false;
    }

    public String getStatus() {
        return this.status;
    }

    public int getReady() {
        return this.ready;
    }
}

